<?php

namespace App\Http\Controllers\Site\Fee;

use App\Http\Controllers\ProjectController;
use App\Jobs\Site\PaymentHistoryJob;
use App\Models\Academic\AcademicAdmissionFeeType;
use App\Models\Academic\AcademicFeeHead;
use App\Models\Academic\AcademicGeneralFeeType;
use App\Models\Academic\AcademicMonthName;
use App\Models\Examinations\Examination;
use App\Models\Site\Accounts\Accounts;
use App\Models\Site\Accounts\AccountsVoucherDetails;
use App\Models\Site\Accounts\SiteAccountsVoucherDetailsStudentPaymentHistoryRecord;
use App\Models\Site\Employee\StudentAssignToTeacher;
use App\Models\Site\Fee\Fine\SiteStudentFeeFine;
use App\Models\Site\Fee\SiteStudentFeeDemandSlipDetails;
use App\Models\Site\Fee\SiteStudentFeeFineAllocation;
use App\Models\Site\Fee\SiteStudentFeeGenerate;
use App\Models\Site\Fee\SiteStudentFeePaymentHistory;
use App\Models\Site\Fee\SiteStudentFeeWaiverOfferHistory;
use App\Models\Site\Role\SiteRole;
use App\Models\Student\StudentHistory;
use App\Models\User\GlobalUser;
use App\Models\User\User;
use App\Models\Site\SiteInfo;
//use App\Models\Site\StudentPaySlip\SiteStudentPaymentSlip;

use Auth;
use Carbon\Carbon;
use Carbon\CarbonPeriod;
use DB;
use Exception;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use JsonSchema\Exception\ValidationException;
use PDF;
use Response;
use Session;
use Error;

class SiteStudentFeePaymentHistoryController extends ProjectController
{
    private $siteStudentFeePaymentHistory;
    private $siteStudentFeeDemandSlipDetails;
    private $siteStudentFeeGenerate;
    private $siteStudentFeeWaiverOfferHistory;

    public function __construct(SiteStudentFeePaymentHistory $siteStudentFeePaymentHistory, SiteStudentFeeDemandSlipDetails $siteStudentFeeDemandSlipDetails,
                                SiteStudentFeeGenerate $siteStudentFeeGenerate, SiteStudentFeeWaiverOfferHistory $siteStudentFeeWaiverOfferHistory)
    {
        $this->middleware('auth');
        //$this->middleware('eduworlduserchecker');
        // $this->middleware('sitepagechecker');
        $this->siteStudentFeePaymentHistory = $siteStudentFeePaymentHistory;
        $this->siteStudentFeeDemandSlipDetails = $siteStudentFeeDemandSlipDetails;
        $this->siteStudentFeeGenerate = $siteStudentFeeGenerate;
        $this->siteStudentFeeWaiverOfferHistory = $siteStudentFeeWaiverOfferHistory;

    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $viewType = 'Fee Collection';
        return view('default.admin.layouts.master', compact('viewType'));
    }

    public function feeCancelIndex()
    {
        $viewType = 'Fee Cancellation';
        return view('default.admin.layouts.master', compact('viewType'));
//        return view('default.admin.sites.fee.fee-cancellation.view', compact('viewType'));
    }

    public function getStudentListForPaymentList(Request $request)
    {
        $data = $request->all();
        $siteStudentList = StudentHistory::with('student')
            ->where('academic_version_id', $request->academic_version_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('status', true)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->when(!empty($data['academic_student_category_id']), function ($query) use ($data) {
                return $query->where('academic_student_category_id', $data['academic_student_category_id']);
            })
            ->when(!empty($data['academic_student_type_id']), function ($query) use ($data) {
                return $query->where('academic_student_type_id', $data['academic_student_type_id']);
            })
            ->when(!empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
            })
            ->when(!empty($data['student_histories_id']), function ($query) use ($data) {
                return $query->where('id', $data['student_histories_id']);
            })
            ->when(!empty($data['search_user_name']), function ($query) use ($data) {
                return $query->whereHas('student', function ($q) use($data){
                    $q->where('username', $data['search_user_name']);
                });
            })
            ->orderBy('student_roll_number')
            ->orderBy('academic_section_id')
            ->orderBy('academic_class_id')
            ->orderBy('academic_department_id')
            ->get();
        return $siteStudentList;

    }
    public function getDemandSlipNoListForPayment()
    {
        $data_list = [];
        $user_role = request()->user()->roles()->pluck('key')->first();
        $student_history_ids = [];
        if($user_role != 'admin'){
            $assign_student_to_teacher_data = StudentAssignToTeacher::where('employee_id', Auth::user()->id)->where('status', 1)->get();

            if(count($assign_student_to_teacher_data)>0){

                $id_list = [];
                $srl = 0;
                foreach ($assign_student_to_teacher_data as $kkkk => $vvv){
                    $student_history_ids = explode(',', $vvv->student_history_ids);
                    foreach ($student_history_ids as $k => $v){
                        $id_list[] = $v;
                        $srl++;
                    }
                }
//                return $id_list;
                $demand_slip_list = SiteStudentFeeDemandSlipDetails::whereIn('student_history_id',$id_list)->where('status', 1)->get();
//                return $demand_slip_list;
                if(count($demand_slip_list)){
                    foreach ($demand_slip_list as $key => $value){
                        $data_list[$key]['id'] = $value->id;
                        $data_list[$key]['slip_no'] = 100000 + $value->id;
                    }
                }

            }
        }else{
            $demand_slip_list = SiteStudentFeeDemandSlipDetails::where('status', 1)->get();
           
            if(count($demand_slip_list)){
                foreach ($demand_slip_list as $key => $value){
                    $data_list[$key]['id'] = $value->id;
                    $data_list[$key]['slip_no'] = 100000 + $value->id;
                }
            }
        }


        return $data_list;
    }

    public function getStudentLastPaymentList(Request $request)
    {
//        return $request;
        $siteStudentList = $this->getStudentListForPaymentList($request);
        $data = $request->all();

        $data_list = array();

        if(count($siteStudentList)){
            $sl = 1;

            foreach ($siteStudentList as $key => $value){
                $std_payment = $this->siteStudentFeePaymentHistory->where('student_history_id', $value->id)
                                ->when($data['search_date'], function ($query) use($data){
                                    return $query->where('payment_date', $data['search_date']);
                                })
                                ->when($data['search_voucher_no'], function ($query) use($data){
                                    return $query->where('voucher_no', $data['search_voucher_no']);
                                })
                                ->where('status', 1)
                                ->orderBy('id','DESC')
                                ->first();

                if($std_payment){
                    $data_list[$sl]['sl'] = $sl;
                    $data_list[$sl]['id'] = $std_payment->id;
                    $data_list[$sl]['student_name'] = $value->student->full_name;
                    $data_list[$sl]['student_roll_number'] = $value->student_roll_number;
                    $data_list[$sl]['user_name'] = $value->student->username;
                    $data_list[$sl]['voucher_no'] = $std_payment->voucher_no;
                    $data_list[$sl]['payment_date'] = $std_payment->payment_date;
                    $data_list[$sl]['paid_amount'] = $std_payment->paid_amount;
                    $data_list[$sl]['due_amount'] = $std_payment->due_amount;
                    $sl++;
                }
            }

        }else{
//            return Response::json(['message' => 'Sorry data not found!'], 411);
            $data = null;
        }
        return $data_list;


    }

    public function singleStudentPaymetCancel(Request $request)
    {

        //=============accounts creation check===============

        $check_accounts_creation = SiteStudentFeePaymentHistory::where('id', $request->id)->first();

        if($check_accounts_creation->accounts_received_status){
            throw new Error('Sorry! this payment has been included in accounts!');
        }

        if($check_accounts_creation->academic_payment_type_key == 'online' || $check_accounts_creation->online_payment_status){
            throw new Error('Sorry! can not be canceled! this payment is paid through online!');
        }


        //==============accoutns create===================

        $payment_history = $this->siteStudentFeePaymentHistory->findOrFail($request->id);
        $paid_amount = $payment_history->paid_amount;
        if($payment_history->site_student_fee_demand_slip_details_id){
            $demand_slip = $this->siteStudentFeeDemandSlipDetails->findOrFail($payment_history->site_student_fee_demand_slip_details_id);
            if($payment_history->due_amount == 0){
                $demand_slip->update([
                    'status' => true,
                ]);
            }
        }

        $demandslip_id_for_last_payment_find = $payment_history->site_student_fee_demand_slip_details_id;

        if($payment_history->delete()){
            $payment_history_exist = SiteStudentFeePaymentHistory::where('site_student_fee_demand_slip_details_id', $demandslip_id_for_last_payment_find)
                ->orderBy('id', 'desc')->first();
            if($payment_history_exist){
                $payment_history_exist->update([
                    'status' => 1,
                ]);
            }
        }

        $fee_fine_details_due_fine = SiteStudentFeeFine::where('site_student_fee_payment_history_id',$request->id)
            ->where('fee_type', 'duefine')
            ->update([
                'status' => true,
                'site_student_fee_payment_history_id' => null,
            ]);

        $fee_fine_details_for_delay_fine = SiteStudentFeeFine::where('site_student_fee_payment_history_id',$request->id)
            ->where('fee_type', 'delayfine')
            ->orWhere('fee_type', 'extrapayment')
            ->delete();



        //============accounts=======================
//        $check_accounts_voucher_payment_history = SiteAccountsVoucherDetailsStudentPaymentHistoryRecord::where('site_student_fee_payment_history_id', $request->id)->first();
//        if($check_accounts_voucher_payment_history){
//            $accounts_voucher_data = AccountsVoucherDetails::where('id', $check_accounts_voucher_payment_history->site_accounts_voucher_detail_id)->first();
//            if($paid_amount == $accounts_voucher_data->transaction_amount){
//                $accounts_data = Accounts::where('site_accounts_voucher_detail_id', $accounts_voucher_data->id)->get();
//                foreach ($accounts_data as $kk => $vl){
//                    $vl->delete();
//                }
//                $accounts_voucher_data->delete();
//                $check_accounts_voucher_payment_history->delete();
//            }else{
//                $accounts_voucher_data->transaction_amount = $accounts_voucher_data->transaction_amount - $paid_amount;
//                $accounts_voucher_data->save();
//
//                $accounts_data = Accounts::where('site_accounts_voucher_detail_id', $accounts_voucher_data->id)->get();
//                foreach ($accounts_data as $kk => $vl){
//                    if($vl->entry == 'cr'){
//                        $accounts_single_data_for_update = Accounts::where('id', $vl->id)->first();
//                        $accounts_single_data_for_update->credit_amount = $accounts_single_data_for_update->credit_amount - $paid_amount;
//                        $accounts_single_data_for_update->save();
//                    }
//                    if($vl->entry == 'dr'){
//                        $accounts_single_data_for_update = Accounts::where('id', $vl->id)->first();
//                        $accounts_single_data_for_update->debit_amount = $accounts_single_data_for_update->debit_amount - $paid_amount;
//                        $accounts_single_data_for_update->save();
//                    }
//
//
//                }
//                $check_accounts_voucher_payment_history->delete();
//            }
//        }



        return Response::json(['message' => 'Payment Successfully Cancelled!', 'mode' => 'Cancelled!'], 200);


    }

    public function getDemandListForPayment(Request $request){
       /// return $request;

        if(!$request->student_registration_number && !$request->demand_slip_no){
            return Response::json(['message' => 'Please, fill the fields!'], 411);
        }

        $user_role = request()->user()->roles()->pluck('key')->first();
        $student_history_ids = [];
        if($user_role != 'admin'){
            $assign_student_to_teacher_data = StudentAssignToTeacher::where('employee_id', Auth::user()->id)->where('status', 1)->get();

            if(count($assign_student_to_teacher_data)>0){

                $id_list = [];
                $srl = 0;
                foreach ($assign_student_to_teacher_data as $kkkk => $vvv){
                    $student_history_ids = explode(',', $vvv->student_history_ids);
                    foreach ($student_history_ids as $k => $v){
                        $id_list[] = $v;
                        $srl++;
                    }
                }

                if($request->student_registration_number){
                    $userList=GlobalUser::where('username', $request->student_registration_number)->select('id')->first();
                    if(!$userList){
                        return Response::json(['message' => 'User ID is not valid!'], 411);
                    }

                    $studentHistoryIDList=StudentHistory::where('user_id',$userList->id)->where('status',1)->pluck('id');
                    $id = $studentHistoryIDList[0];


                    if(!in_array(strval($id), $id_list)){
                        return Response::json(['message' => 'You are unauthorised for this payment!', 'mode' => 'Error!'],411);
                    }

                    $demanSlipId=SiteStudentFeeDemandSlipDetails::whereIn('student_history_id', $studentHistoryIDList)
                        ->where('status',1)
                        ->orderBy('id', 'desc')
                        ->first();

                    if(!$demanSlipId){
                        $paidDemanSlipId=SiteStudentFeeDemandSlipDetails::whereIn('student_history_id', $studentHistoryIDList)
                            ->where('status',false)
                            ->orderBy('id', 'desc')
                            ->first();
                        if($paidDemanSlipId){
                            return Response::json(['message' => 'There are no rest Demand Slip!', 'mode' => 'Error!'],411);
                        }
                    }

                    $slip_number = $demanSlipId->id;
                    $slip_no = $demanSlipId->id+100000;
                }else if($request->demand_slip_no){
                    $slip_number = $request->demand_slip_no - 100000;
                    $slip_no = $request->demand_slip_no;
                }
//                    $student_history_ids = $assign_student_to_teacher_data->student_history_ids;
            }else{
                return Response::json(['message' => 'You are unauthorised for this payment!', 'mode' => 'Error!'],411);
            }
        }else{
            if($request->student_registration_number){
                $userList=GlobalUser::where('username', $request->student_registration_number)->select('id')->first();
                if(!$userList){
                    return Response::json(['message' => 'User ID is not valid!'], 411);
                }
                $studentHistoryIDList=StudentHistory::where('user_id',$userList->id)->where('status',1)->pluck('id');

                $demanSlipId=SiteStudentFeeDemandSlipDetails::whereIn('student_history_id', $studentHistoryIDList)
                    ->where('status',1)
                    ->orderBy('id', 'desc')
                    ->first();

                if(!$demanSlipId){
                    $paidDemanSlipId=SiteStudentFeeDemandSlipDetails::whereIn('student_history_id', $studentHistoryIDList)
                        ->where('status',false)
                        ->orderBy('id', 'desc')
                        ->first();
                    if($paidDemanSlipId){
                        return Response::json(['message' => 'There are no rest Demand Slip!', 'mode' => 'Error!'],411);
                    }

                }

                $slip_number = $demanSlipId->id;
                $slip_no = $demanSlipId->id+100000;
            }else if($request->demand_slip_no){
                $slip_number = $request->demand_slip_no - 100000;
                $slip_no = $request->demand_slip_no;

            }
        }


        $paidDemanSlipIdcheck=SiteStudentFeeDemandSlipDetails::where('id', $slip_number)
            ->first();
//        return $paidDemanSlipIdcheck;

        if(!$paidDemanSlipIdcheck){
            return Response::json(['message' => 'Invalid Demand Slip!', 'mode' => 'Error!'],411);
        }else{
            if($paidDemanSlipIdcheck->status==false){
                return Response::json(['message' => 'This Demand Slip Amount Is Paid!', 'mode' => 'Error!'],411);
            }
        }

        $demand_slip_details = SiteStudentFeeDemandSlipDetails::where('id', $slip_number)->first();
        $student_details = StudentHistory::
        with(['student','stClass','accGroup','section', 'department'])
            ->where('id',$demand_slip_details->student_history_id)
            ->first();

        $user_details = GlobalUser::where('id',$demand_slip_details->created_by)->first();
        $user_name = $user_details->first_name;

        $fee_generate_id_splite = explode(',', $demand_slip_details->site_student_fee_generate_ids);
        $fee_generate_list = SiteStudentFeeGenerate::whereIn('id', $fee_generate_id_splite)->get();

        $waiver_generate_id_splite = explode(',', $demand_slip_details->site_student_fee_waiver_offer_history_ids);
        $waiver_generate_list = SiteStudentFeeWaiverOfferHistory::whereIn('id', $waiver_generate_id_splite)->get();

        //==================Fee List=========
        $fee_allocation_details_array = [];
        $fee_allocation_details_arr = Array();
        foreach ($fee_generate_list as $key => $value){

            $fee_allocation_detail= SiteStudentFeeFineAllocation::
            with(['academicFeeHead','academicFeeGroup','academicFeeSubHead'])
                ->where('id',$value->site_student_fee_fine_allocation_id)->first();


            if ($fee_allocation_detail->academicFeeHead->head_key == 'admission'){
                $fee_type = AcademicAdmissionFeeType::where('id', $value->fee_head_type_id)->first();
                $fee_allocation_details_arr['fee_type_name'] = $fee_type->name;

            }elseif ($fee_allocation_detail->academicFeeHead->head_key == 'monthly'){
                $fee_type = AcademicMonthName::where('id', $value->fee_head_type_id)->first();
                $fee_allocation_details_arr['fee_type_name'] = $fee_type->name;

            }elseif ($fee_allocation_detail->academicFeeHead->head_key == 'examination'){
                $fee_type = Examination::where('id', $value->fee_head_type_id)->first();
                $fee_allocation_details_arr['fee_type_name'] = $fee_type->examination_name;

            }elseif ($fee_allocation_detail->academicFeeHead->head_key == 'general'){
                $fee_type = AcademicGeneralFeeType::where('id', $value->fee_head_type_id)->first();
                $fee_allocation_details_arr['fee_type_name'] = $fee_type->name;
            }

            $fee_allocation_details_arr['academic_fee_head']=$fee_allocation_detail->academicFeeHead;
            $fee_allocation_details_arr['academic_fee_sub_head']=$fee_allocation_detail->academicFeeSubHead;

            $fee_allocation_details_array[$key]=array_merge($fee_allocation_details_arr, $value->toArray());

        }

        $fee_allocation_details=collect($fee_allocation_details_array);
        $total_in_word = $this->convertNumberToWord($demand_slip_details->total_amount);
        $tot_amount =  $demand_slip_details->total_amount;


        $fee_allocation_details_list=$this->feeHeadSubHeadTypeMultiStemArray($fee_allocation_details);
     
        //==================Waiver List =========
        $waiver_allocation_details_array = [];
        $waiver_allocation_details_arr = Array();
        foreach ($waiver_generate_list as $key => $value){


            if($value->site_student_fee_fine_allocation_id){


                $waiver_allocation_detail= SiteStudentFeeFineAllocation::
                with(['academicFeeHead','academicFeeGroup','academicFeeSubHead'])
                    ->where('id',$value->site_student_fee_fine_allocation_id)->first();


                if ($waiver_allocation_detail->academicFeeHead->head_key == 'admission'){
                    $waiver_type = AcademicAdmissionFeeType::where('id', $value->fee_head_type_id)->first();
                    $waiver_allocation_details_arr['fee_type_name'] = $waiver_type->name;

                }elseif ($waiver_allocation_detail->academicFeeHead->head_key == 'monthly'){
                    $waiver_type = AcademicMonthName::where('id', $value->fee_head_type_id)->first();
                    $waiver_allocation_details_arr['fee_type_name'] = $waiver_type->name;

                }elseif ($waiver_allocation_detail->academicFeeHead->head_key == 'examination'){
                    $waiver_type = Examination::where('id', $value->fee_head_type_id)->first();
                    $waiver_allocation_details_arr['fee_type_name'] = $waiver_type->examination_name;

                }elseif ($waiver_allocation_detail->academicFeeHead->head_key == 'general'){
                    $waiver_type = AcademicGeneralFeeType::where('id', $value->fee_head_type_id)->first();
                    $waiver_allocation_details_arr['fee_type_name'] = $waiver_type->name;
                }


                $waiver_allocation_details_arr['academic_fee_head']=$waiver_allocation_detail->academicFeeHead;
                $waiver_allocation_details_arr['academic_fee_sub_head']=$waiver_allocation_detail->academicFeeSubHead;


                $waiver_allocation_details_array[$key]=array_merge($waiver_allocation_details_arr, $value->toArray());
            }

        }
        //================due fine=======================

        $check_paymnet_happend = SiteStudentFeePaymentHistory::where('site_student_fee_demand_slip_details_id', $slip_number)->first();

        if($check_paymnet_happend){
            $due_fine = SiteStudentFeeFine::where('site_student_fee_demand_slip_details_id', $paidDemanSlipIdcheck->previous_site_student_fee_demand_slip_detail_id)
                ->where('fee_type', 'duefine')
                ->get();
            if(count($due_fine)>0){
                $due_fine_check = $due_fine;
            }else{
                $due_fine_check = SiteStudentFeeFine::where('status', 1)->where('student_history_id', $demand_slip_details->student_history_id)->get();
            }
        }else{
            $due_fine_check = SiteStudentFeeFine::where('status', 1)->where('student_history_id', $demand_slip_details->student_history_id)->get();
        
        }  

        $site_std_fee_fine_id=[];
        $fee_due_fine=0;
        if(count($due_fine_check)){
            foreach ($due_fine_check as $key => $value){
                $fee_due_fine+= $value->fine_amount;
                $site_std_fee_fine_id[$key] = $value->id;
            }

        }else{
            $fee_due_fine = 0;
        }

        $mytime = Carbon::now();
        $today_date =  $mytime->toDateString();


        $fee_delay_fine = 0;

        if($demand_slip_details->payment_from_date){
            $start_date = $demand_slip_details->payment_from_date;
            $end_date = $demand_slip_details->payment_to_date;

            $period = CarbonPeriod::create($start_date, $end_date);

            $delay_fine_test = 1;
            $delay_fine = 0;

            foreach ($period as $date) {
                $formated_date =  $date->format('Y-m-d');
                if($formated_date == $today_date){
                    $delay_fine_test = 0;
                }
            }

            if($delay_fine_test==1){
                $delay_fine = $demand_slip_details->delay_fine;
            }else{
                $delay_fine = 0;
            }

//
//                if($delay_fine>0){
//                    $fee_fine_create = SiteStudentFeeFine::create([
//                        'site_student_fee_demand_slip_details_id' => $demand_slip_details->id,
//                        'fine_amount' => $delay_fine,
//                    ]);
//                }

            $fee_delay_fine = $delay_fine;
        }
        $extra_fine = 0;
        $check_extra_fine = SiteStudentFeeFine::where('site_student_fee_demand_slip_details_id',$slip_number)->where('fee_type', 'extrafine')->get();
        if(count($check_extra_fine)>0){
            foreach ($check_extra_fine as $kk => $vl){
                $extra_fine+=$vl->fine_amount;
            }
        }



        $total_fee_fine = $fee_delay_fine + $fee_due_fine + $extra_fine;

    
//        return $fee_due_fine;

        $total_fee_fine = number_format((float)$total_fee_fine, 2, '.', '');

        $total_amount = $tot_amount + $total_fee_fine;
        $total_amount = number_format((float)$total_amount, 2, '.', '');

        $waiver_allocation=collect($waiver_allocation_details_array);

        $waiver_allocation_details=$this->feeHeadSubHeadTypeMultiStemArray($waiver_allocation);

        $previous_paid_amount = 0;
        $payment_list_by_demand_slip = SiteStudentFeePaymentHistory::where('site_student_fee_demand_slip_details_id', $slip_number)->get();
        if(count($payment_list_by_demand_slip)){
            foreach ($payment_list_by_demand_slip as $kk => $vv){
                $previous_paid_amount+= $vv->paid_amount;
            }
        }

        $finalArray=compact('demand_slip_details','student_details','slip_no',
            'fee_allocation_details_list', 'waiver_allocation_details', 'total_amount','user_name','total_in_word','fee_delay_fine','fee_due_fine','total_fee_fine','site_std_fee_fine_id','previous_paid_amount');

        return $finalArray;
    }

    public function getDemandListForPaymentEdit(Request $request){
//        return $request;


        $slip_number = $request->demand_slip_no - 100000;
        $slip_no = $request->demand_slip_no;
//        return $request->demand_slip_no;

        $demand_slip_details = SiteStudentFeeDemandSlipDetails::where('id', $slip_number)->first();
        $student_details = StudentHistory::
        with(['student','stClass','accGroup','section', 'department'])
            ->where('id',$demand_slip_details->student_history_id)
            ->first();

        $user_details = GlobalUser::where('id',$demand_slip_details->created_by)->first();
        $user_name = $user_details->first_name;

        $fee_generate_id_splite = explode(',', $demand_slip_details->site_student_fee_generate_ids);
        $fee_generate_list = SiteStudentFeeGenerate::whereIn('id', $fee_generate_id_splite)->get();

        $waiver_generate_id_splite = explode(',', $demand_slip_details->site_student_fee_waiver_offer_history_ids);
        $waiver_generate_list = SiteStudentFeeWaiverOfferHistory::whereIn('id', $waiver_generate_id_splite)->get();

        //==================Fee List=========
        $fee_allocation_details_array = [];
        $fee_allocation_details_arr = Array();
        foreach ($fee_generate_list as $key => $value){

            $fee_allocation_detail= SiteStudentFeeFineAllocation::
            with(['academicFeeHead','academicFeeGroup','academicFeeSubHead'])
                ->where('id',$value->site_student_fee_fine_allocation_id)->first();


            if ($fee_allocation_detail->academicFeeHead->head_key == 'admission'){
                $fee_type = AcademicAdmissionFeeType::where('id', $value->fee_head_type_id)->first();
                $fee_allocation_details_arr['fee_type_name'] = $fee_type->name;

            }elseif ($fee_allocation_detail->academicFeeHead->head_key == 'monthly'){
                $fee_type = AcademicMonthName::where('id', $value->fee_head_type_id)->first();
                $fee_allocation_details_arr['fee_type_name'] = $fee_type->name;

            }elseif ($fee_allocation_detail->academicFeeHead->head_key == 'examination'){
                $fee_type = Examination::where('id', $value->fee_head_type_id)->first();
                $fee_allocation_details_arr['fee_type_name'] = $fee_type->examination_name;

            }elseif ($fee_allocation_detail->academicFeeHead->head_key == 'general'){
                $fee_type = AcademicGeneralFeeType::where('id', $value->fee_head_type_id)->first();
                $fee_allocation_details_arr['fee_type_name'] = $fee_type->name;
            }

            $fee_allocation_details_arr['academic_fee_head']=$fee_allocation_detail->academicFeeHead;
            $fee_allocation_details_arr['academic_fee_sub_head']=$fee_allocation_detail->academicFeeSubHead;

            $fee_allocation_details_array[$key]=array_merge($fee_allocation_details_arr, $value->toArray());

        }

        $fee_allocation_details=collect($fee_allocation_details_array);
        $total_in_word = $this->convertNumberToWord($demand_slip_details->total_amount);
        $tot_amount =  $demand_slip_details->total_amount;


        $fee_allocation_details_list=$this->feeHeadSubHeadTypeMultiStemArray($fee_allocation_details);

        //==================Waiver List =========
        $waiver_allocation_details_array = [];
        $waiver_allocation_details_arr = Array();
        foreach ($waiver_generate_list as $key => $value){


            if($value->site_student_fee_fine_allocation_id){


                $waiver_allocation_detail= SiteStudentFeeFineAllocation::
                with(['academicFeeHead','academicFeeGroup','academicFeeSubHead'])
                    ->where('id',$value->site_student_fee_fine_allocation_id)->first();


                if ($waiver_allocation_detail->academicFeeHead->head_key == 'admission'){
                    $waiver_type = AcademicAdmissionFeeType::where('id', $value->fee_head_type_id)->first();
                    $waiver_allocation_details_arr['fee_type_name'] = $waiver_type->name;

                }elseif ($waiver_allocation_detail->academicFeeHead->head_key == 'monthly'){
                    $waiver_type = AcademicMonthName::where('id', $value->fee_head_type_id)->first();
                    $waiver_allocation_details_arr['fee_type_name'] = $waiver_type->name;

                }elseif ($waiver_allocation_detail->academicFeeHead->head_key == 'examination'){
                    $waiver_type = Examination::where('id', $value->fee_head_type_id)->first();
                    $waiver_allocation_details_arr['fee_type_name'] = $waiver_type->examination_name;

                }elseif ($waiver_allocation_detail->academicFeeHead->head_key == 'general'){
                    $waiver_type = AcademicGeneralFeeType::where('id', $value->fee_head_type_id)->first();
                    $waiver_allocation_details_arr['fee_type_name'] = $waiver_type->name;
                }


                $waiver_allocation_details_arr['academic_fee_head']=$waiver_allocation_detail->academicFeeHead;
                $waiver_allocation_details_arr['academic_fee_sub_head']=$waiver_allocation_detail->academicFeeSubHead;


                $waiver_allocation_details_array[$key]=array_merge($waiver_allocation_details_arr, $value->toArray());
            }

        }
        //================due fine=======================

        $due_fine_check = SiteStudentFeeFine::where('student_history_id', $demand_slip_details->student_history_id)->get();
//        return $due_fine_check;
        $fee_fine=0;
        $site_std_fee_fine_id=[];
        $fee_due_fine=0;
        if(count($due_fine_check)){
            foreach ($due_fine_check as $key => $value){
                $fee_due_fine+= $value->fine_amount;
                $site_std_fee_fine_id[$key] = $value->id;
            }

        }else{
            $fee_due_fine = 0;
        }

        $mytime = Carbon::now();
        $today_date =  $mytime->toDateString();


        $fee_delay_fine = 0;
        $fee_due_fine = 0;

        if($demand_slip_details->payment_from_date){
            $start_date = $demand_slip_details->payment_from_date;
            $end_date = $demand_slip_details->payment_to_date;

            $period = CarbonPeriod::create($start_date, $end_date);

            $delay_fine_test = 1;
            $delay_fine = 0;

            foreach ($period as $date) {
                $formated_date =  $date->format('Y-m-d');
                if($formated_date == $today_date){
                    $delay_fine_test = 0;
                }
            }

            if($delay_fine_test==1){
                $delay_fine = $demand_slip_details->delay_fine;
            }else{
                $delay_fine = 0;
            }

//
//                if($delay_fine>0){
//                    $fee_fine_create = SiteStudentFeeFine::create([
//                        'site_student_fee_demand_slip_details_id' => $demand_slip_details->id,
//                        'fine_amount' => $delay_fine,
//                    ]);
//                }

            $fee_delay_fine = $delay_fine;
        }


        $total_fee_fine = $fee_delay_fine + $fee_due_fine;

//        return $fee_due_fine;

        $total_fee_fine = number_format((float)$total_fee_fine, 2, '.', '');

        $total_amount = $tot_amount + $total_fee_fine;
        $total_amount = number_format((float)$total_amount, 2, '.', '');

        $waiver_allocation=collect($waiver_allocation_details_array);

        $waiver_allocation_details=$this->feeHeadSubHeadTypeMultiStemArray($waiver_allocation);


        $finalArray=compact('demand_slip_details','student_details','slip_no',
            'fee_allocation_details_list', 'waiver_allocation_details', 'total_amount','user_name','total_in_word','fee_delay_fine','fee_due_fine','total_fee_fine','site_std_fee_fine_id');

        return $finalArray;
    }


    private function feeHeadSubHeadTypeMultiStemArray($fee_allocation_details){

//        return $fee_allocation_details;
        $head_Id=$fee_allocation_details->pluck('academic_fee_head.id')->unique();
        $fee_head_list=AcademicFeeHead::get();


        $fee_head_arr=Array();
        $fee_head_array=[];
        foreach ($head_Id as $key => $value){

            $head_list=$fee_head_list->where('id',$value)->first();

            $fee_head_arr['id']=$value;
            $fee_head_arr['name']=$head_list->name;


            $fee_head_pre_array=[];
            foreach ($fee_allocation_details as $keys => $values){
                if($value==$values['academic_fee_head']['id']){

                    $fee_head_pre_array[$keys]=$values;
                }
            }

            $fee_head_pre_array_collect=collect($fee_head_pre_array);
            $fee_head_pre_array_collect_id= $fee_head_pre_array_collect->pluck('fee_head_type_id')->unique();


            $fee_head_type_arr=Array();
            $fee_head_type_array=[];
            $sub_head_full_count=[];
            foreach ($fee_head_pre_array_collect_id as $keyt => $valuet){

                $fee_head_type_listt=$fee_head_pre_array_collect->where('fee_head_type_id', $valuet)->first();
//                return $fee_head_type_listt;

                $fee_head_type_arr['fee_type_id']=$valuet;
                $fee_head_type_arr['fee_type_name']=$fee_head_type_listt['fee_type_name'];


                $fee_head_type_pre_array=[];
                foreach ($fee_head_pre_array_collect as $keytt => $valuett){

                    if($valuet==$valuett['fee_head_type_id']){
                        $fee_head_type_pre_array[$keytt]=$valuett;
                    }
                }

                $fee_head_type_arr['fee_sub_head_count']=count($fee_head_type_pre_array);
                $fee_head_type_arr['fee_sub_head']=$fee_head_type_pre_array;

                $sub_head_full_count[$keyt]=count($fee_head_type_pre_array);

                $fee_head_type_array[$keyt]=array_merge($fee_head_type_arr);

            }

            $fee_head_arr['head_type_base_sub_head_count']=array_sum($sub_head_full_count);
            $fee_head_arr['head_type']=$fee_head_type_array;

            $fee_head_array[$key]=array_merge($fee_head_arr);
        }
        $fee_allocation_details_list=collect($fee_head_array);

        return $fee_allocation_details_list;
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function getStudentPaySlipList()
    {
        $slip = new SiteStudentPaymentSlip();
        $slip_list = $slip->orderBy('id', 'DESC')->get();
        return $slip_list;
    }

    public function singleStudentPaymentPDF($print_status, $voucher_no)
    {
//        return $voucher_no;
        $payment_history_details = $this->siteStudentFeePaymentHistory->where('voucher_no', $voucher_no)->first();

        $demand_slip_details = $this->siteStudentFeeDemandSlipDetails->where('id', $payment_history_details->site_student_fee_demand_slip_details_id)->first();

        $fee_generate_id_splite = explode(',', $demand_slip_details->site_student_fee_generate_ids);
        $fee_generate_list = $this->siteStudentFeeGenerate->whereIn('id', $fee_generate_id_splite)->get();

        $waiver_generate_id_splite = explode(',', $demand_slip_details->site_student_fee_waiver_offer_history_ids);

        $waiver_generate_list =  $this->siteStudentFeeWaiverOfferHistory->whereIn('id', $waiver_generate_id_splite)->get();

        $student_details = StudentHistory::with(['student','stClass','accGroup','section', 'department'])
                                                ->where('id', $payment_history_details->student_history_id)
                                                ->first();

        $slip_no = $demand_slip_details->id + 100000;

        $paid_amount = $payment_history_details->paid_amount;
        $due_amount = $payment_history_details->due_amount;

        //==================Fee List=========
        $fee_allocation_details_array = [];
        $fee_allocation_details_arr = Array();
        foreach ($fee_generate_list as $key => $value){

            $fee_allocation_detail= SiteStudentFeeFineAllocation::
            with(['academicFeeHead','academicFeeGroup','academicFeeSubHead'])
                ->where('id',$value->site_student_fee_fine_allocation_id)->first();


            if ($fee_allocation_detail->academicFeeHead->head_key == 'admission'){
                $fee_type = AcademicAdmissionFeeType::where('id', $value->fee_head_type_id)->first();
                $fee_allocation_details_arr['fee_type_name'] = $fee_type->name;

            }elseif ($fee_allocation_detail->academicFeeHead->head_key == 'monthly'){
                $fee_type = AcademicMonthName::where('id', $value->fee_head_type_id)->first();
                $fee_allocation_details_arr['fee_type_name'] = $fee_type->name;

            }elseif ($fee_allocation_detail->academicFeeHead->head_key == 'examination'){
                $fee_type = Examination::where('id', $value->fee_head_type_id)->first();
                $fee_allocation_details_arr['fee_type_name'] = $fee_type->examination_name;

            }elseif ($fee_allocation_detail->academicFeeHead->head_key == 'general'){
                $fee_type = AcademicGeneralFeeType::where('id', $value->fee_head_type_id)->first();
                $fee_allocation_details_arr['fee_type_name'] = $fee_type->name;
            }

            $fee_allocation_details_arr['academic_fee_head']=$fee_allocation_detail->academicFeeHead;
            $fee_allocation_details_arr['academic_fee_sub_head']=$fee_allocation_detail->academicFeeSubHead;

            $fee_allocation_details_array[$key]=array_merge($fee_allocation_details_arr, $value->toArray());

        }

        $fee_allocation_details=collect($fee_allocation_details_array);
        $total_paid_amount_in_word = $this->convertNumberToWord($paid_amount);



        $fee_allocation_details_list=$this->feeHeadSubHeadTypeMultiStemArray($fee_allocation_details);

        //==================Waiver List =========
        $waiver_allocation_details_array = [];
        $waiver_allocation_details_arr = Array();
        foreach ($waiver_generate_list as $key => $value){


            if($value->site_student_fee_fine_allocation_id){


                $waiver_allocation_detail= SiteStudentFeeFineAllocation::
                with(['academicFeeHead','academicFeeGroup','academicFeeSubHead'])
                    ->where('id',$value->site_student_fee_fine_allocation_id)->first();


                if ($waiver_allocation_detail->academicFeeHead->head_key == 'admission'){
                    $waiver_type = AcademicAdmissionFeeType::where('id', $value->fee_head_type_id)->first();
                    $waiver_allocation_details_arr['fee_type_name'] = $waiver_type->name;

                }elseif ($waiver_allocation_detail->academicFeeHead->head_key == 'monthly'){
                    $waiver_type = AcademicMonthName::where('id', $value->fee_head_type_id)->first();
                    $waiver_allocation_details_arr['fee_type_name'] = $waiver_type->name;

                }elseif ($waiver_allocation_detail->academicFeeHead->head_key == 'examination'){
                    $waiver_type = Examination::where('id', $value->fee_head_type_id)->first();
                    $waiver_allocation_details_arr['fee_type_name'] = $waiver_type->examination_name;

                }elseif ($waiver_allocation_detail->academicFeeHead->head_key == 'general'){
                    $waiver_type = AcademicGeneralFeeType::where('id', $value->fee_head_type_id)->first();
                    $waiver_allocation_details_arr['fee_type_name'] = $waiver_type->name;
                }


                $waiver_allocation_details_arr['academic_fee_head']=$waiver_allocation_detail->academicFeeHead;
                $waiver_allocation_details_arr['academic_fee_sub_head']=$waiver_allocation_detail->academicFeeSubHead;


                $waiver_allocation_details_array[$key]=array_merge($waiver_allocation_details_arr, $value->toArray());
            }

        }
        $waiver_allocation=collect($waiver_allocation_details_array);

        $waiver_allocation_details=$this->feeHeadSubHeadTypeMultiStemArray($waiver_allocation);

        $previous_paid_amount = SiteStudentFeePaymentHistory::where('id', '<', $payment_history_details->id)
            ->where('site_student_fee_demand_slip_details_id', $demand_slip_details->id)->sum('paid_amount');

        $fee_fine_amount_with_present_demand_slip = SiteStudentFeeFine::where('site_student_fee_demand_slip_details_id',$demand_slip_details->id)
            ->orWhere('site_student_fee_demand_slip_details_id',$demand_slip_details)->sum('fine_amount');

        $fee_fine_amount_with_previous_demand_slip = SiteStudentFeeFine::where('site_student_fee_demand_slip_details_id',$demand_slip_details->previous_site_student_fee_demand_slip_detail_id)
            ->where('fee_type','duefine')
            ->sum('fine_amount');

//        $fee_fine_data = SiteStudentFeeFine::where('site_student_fee_payment_history_id', $payment_history_details->id)->get();
        $fee_fine = $fee_fine_amount_with_present_demand_slip + $fee_fine_amount_with_previous_demand_slip;
//        if(count($fee_fine_data)){
//
//            foreach ($fee_fine_data as $key => $value){
//                $fee_fine+= $value->fine_amount;
//            }
//        }

        $fee_fine = number_format((float)$fee_fine, 2, '.', '');


        $total_amount =  $demand_slip_details->total_amount + $fee_fine;

        $total_amount = number_format((float)$total_amount, 2, '.', '');

        $title_view = 'Payment Slip';
        $user_name = "";
        $payment_date = $payment_history_details->payment_date;

        $report_tittle = '<b>Payment Slip</b><br>'.$payment_date;
        $report_tittle2  = '<b><br>Slip No: </b>'.$voucher_no;

        $slip_count = [1,2,3];

        if ($print_status==1){
            $pdf = PDF::loadView('default.admin.site.student-fee.report.payment-voucher-for-pos', compact('title_view','demand_slip_details','student_details','slip_no','voucher_no',
                'payment_date','slip_count','fee_allocation_details_list','previous_paid_amount','report_tittle','report_tittle2','waiver_allocation_details', 'total_amount','user_name','total_paid_amount_in_word','paid_amount','due_amount','fee_fine'));
        }else{

            $pdf = PDF::loadView('default.admin.site.student-fee.report.payment-voucher-pdf', compact('title_view','demand_slip_details','student_details','slip_no','voucher_no',
                'payment_date','previous_paid_amount','report_tittle','report_tittle2','fee_allocation_details_list', 'waiver_allocation_details', 'total_amount','user_name','total_paid_amount_in_word','paid_amount','due_amount','fee_fine'));
        }


        return $pdf->stream(time() . '-student-payment.pdf');

//        return [$demand_slip_details,$student_details,$slip_no,$voucher_no,$fee_allocation_details_list,$waiver_allocation_details,$total_amount,$total_in_word];



    }


    public function getStudentPaySlipPdf($voucher_no)
    {
//        $demand_slip_details = SiteStudentFeeDemandSlipDetails::with(['siteStudentFeePaymentHistory'])->where('slip_no', $slip_id)->first();
        $payment_history_details = SiteStudentFeePaymentHistory::with(['siteStudentFeeDemandSlipDetails'])->where('voucher_no', $voucher_no)->first();
        $student_details = StudentHistory::with(['student','stClass','accGroup','section'])->where('id',$payment_history_details->student_history_id)->first();
        $voucher_no = $voucher_no;
        $user_details = User::where('id',$payment_history_details->created_by)->where('site_id', Session::get('SITE_ID'))->first();
        $user_name = $user_details->first_name;

        $fee_generate_id_splite = explode(',', $payment_history_details->siteStudentFeeDemandSlipDetails->site_student_fee_generate_ids);
        $fee_generate_list = SiteStudentFeeGenerate::whereIn('id', $fee_generate_id_splite)->get();
        $fee_allocation_details = [];

        foreach ($fee_generate_list as $key => $value){

            $fee_allocation_details[$key] = SiteStudentFeeFineAllocation::with(['academicFeeHead','academicFeeGroup','academicFeeSubHead'])->where('id',$value->site_student_fee_fine_allocation_id)->first();
            foreach ($fee_allocation_details as $k => $v){

                if ($v->academicFeeHead->name == 'Admission'){
                    $fee_type = AcademicAdmissionFeeType::where('id', $value->fee_head_type_id)->first();
                    $fee_allocation_details[$key]['fee_type_name'] = $fee_type->name;

                }elseif ($v->academicFeeHead->name == 'Monthly'){
                    $fee_type = AcademicMonthName::where('id', $value->fee_head_type_id)->first();
                    $fee_allocation_details[$key]['fee_type_name'] = $fee_type->name;

                }elseif ($v->academicFeeHead->name == 'Examination'){
                    $fee_type = Examination::where('id', $value->fee_head_type_id)->first();
                    $fee_allocation_details[$key]['fee_type_name'] = $fee_type->examination_name;
                }
            }

        }

        $paid_amount_in_word = $this->convertNumberToWord($payment_history_details->paid_amount);
        $total_with_due =  $payment_history_details->siteStudentFeeDemandSlipDetails['fee_amount'] + $payment_history_details->siteStudentFeeDemandSlipDetails['previous_due'];
        $pdf = PDF::loadView('default.admin.site.student-fee.report.payment-voucher-pdf',
            compact('payment_history_details','student_details','voucher_no','fee_allocation_details','total_with_due','user_name','paid_amount_in_word'));
        return $pdf->stream(time() . '-student-payment.pdf');


        $pdf = PDF::loadView('default.admin.site.student-fee.report.fee-report', compact('slip', 'std_name', 'std_roll', 'current_date', 'final', 'total', 'class', 'section', 'site_address', 'report_tittle'));
        return $pdf->stream(time() . '-student-payment.pdf');

//        $pdf = PDF::loadView('default.admin.site.attendance.report.routine-report2', compact('slip_id','std_name','std_roll','current_date','final','total','class_list','section_list','site_address','report_tittle'));
//        return $pdf->stream(time() . '-student-payment.pdf');

    }





    public function getMultipleStudentDemandSlipListForPayment(Request $request){

//        return $request;
        $data = $request->all();

        if($request->academic_class_id){
//            return 'ok';
            $user_role = request()->user()->roles()->pluck('key')->first();
            $student_history_ids = [];
            if($user_role != 'admin'){
                $assign_student_to_teacher_data = StudentAssignToTeacher::where('employee_id', Auth::user()->id)
                                                    ->where('academic_version_id',$request->academic_version_id)
                                                    ->where('academic_shift_id',$request->academic_shift_id)
                                                    ->where('academic_year_id',$request->academic_year_id)
                                                    ->where('academic_class_id',$request->academic_class_id)
                                                    ->where('status',true)
                                                    ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                                                        return $query->where('academic_department_id', $data['academic_department_id']);
                                                    })
                                                    ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                                                        return $query->where('academic_section_id', $data['academic_section_id']);
                                                    })
                                                    ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                                                        return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                                                    })->first();
                if($assign_student_to_teacher_data){
                    $student_history_ids = explode(',', $assign_student_to_teacher_data->student_history_ids);
//                    $student_history_ids = $assign_student_to_teacher_data->student_history_ids;
                }
                if($request->academic_class_group_present){

                    $siteStudentIDs=StudentHistory::with(['student'=>function($query){
                        $query->select('id', 'username');
                    },'stClass','accGroup','section', 'department',
                        'siteStudentFeeDemandSlipDetails'=>function($query){
                            $query->where('status', true);


                        }])->when(!empty($data['student_history_id']), function ($query) use ($data) {
                        return $query->where('id', $data['student_history_id']);
                    })

                        ->whereIn('id',$student_history_ids)
                        ->where('academic_version_id',$request->academic_version_id)
                        ->where('academic_shift_id',$request->academic_shift_id)
                        ->where('academic_year_id',$request->academic_year_id)
                        ->where('academic_class_id',$request->academic_class_id)
                        ->where('status',true)
                        ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                            return $query->where('academic_department_id', $data['academic_department_id']);
                        })
                        ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                            return $query->where('academic_section_id', $data['academic_section_id']);
                        })
                        ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                            return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                        })
                        ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                            return $query->where('academic_session_id', $data['academic_session_id']);
                        })
                        ->when(!empty($data['academic_student_category_id']), function ($query) use ($data) {
                            return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                        })
                        ->when(!empty($data['academic_student_type_id']), function ($query) use ($data) {
                            return $query->where('academic_student_type_id', $data['academic_student_type_id']);
                        })
                        ->when(!empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                            return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                        })
                        ->orderBy('student_roll_number')
                        ->orderBy('academic_section_id')
                        ->orderBy('academic_class_group_id')
                        ->orderBy('academic_class_id')
                        ->orderBy('academic_department_id')
                        ->orderBy('academic_shift_id')
                        ->get(['id','user_id', 'site_id', 'student_roll_number', 'academic_class_id', 'academic_class_group_id',
                            'academic_session_id', 'academic_department_id']);


                }else{


                    $siteStudentIDs=StudentHistory::with(['student'=>function($query){
                        $query->select('id', 'username');
                    },'stClass','accGroup','section', 'department',
                        'siteStudentFeeDemandSlipDetails'=>function($query){
                            $query->where('status', true);

                        }])->when(!empty($data['student_history_id']), function ($query) use ($data) {
                        return $query->where('id', $data['student_history_id']);
                    })

                        ->whereIn('id',$student_history_ids)
                        ->where('academic_version_id',$request->academic_version_id)
                        ->where('academic_shift_id',$request->academic_shift_id)
                        ->where('academic_year_id',$request->academic_year_id)
                        ->where('academic_class_id',$request->academic_class_id)
                        ->where('status',true)
                        ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                            return $query->where('academic_department_id', $data['academic_department_id']);
                        })
                        ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                            return $query->where('academic_section_id', $data['academic_section_id']);
                        })
                        ->when(!empty($data['academic_student_category_id']), function ($query) use ($data) {
                            return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                        })
                        ->when(!empty($data['academic_student_type_id']), function ($query) use ($data) {
                            return $query->where('academic_student_type_id', $data['academic_student_type_id']);
                        })
                        ->when(!empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                            return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                        })
                        ->orderBy('student_roll_number')
                        ->orderBy('academic_section_id')
                        ->orderBy('academic_class_group_id')
                        ->orderBy('academic_class_id')
                        ->orderBy('academic_department_id')
                        ->orderBy('academic_shift_id')
                        ->get(['id','user_id', 'site_id', 'student_roll_number', 'academic_class_id', 'academic_class_group_id',
                            'academic_session_id', 'academic_department_id']);

                }
            }else{

                if($request->academic_class_group_present){

                    $siteStudentIDs=StudentHistory::with(['student'=>function($query){
                        $query->select('id', 'username');
                    },'stClass','accGroup','section', 'department',
                        'siteStudentFeeDemandSlipDetails'=>function($query){
                            $query->where('status', true);


                        }])->when(!empty($data['student_history_id']), function ($query) use ($data) {
                        return $query->where('id', $data['student_history_id']);
                    })


                        ->where('academic_version_id',$request->academic_version_id)
                        ->where('academic_shift_id',$request->academic_shift_id)
                        ->where('academic_year_id',$request->academic_year_id)
                        ->where('academic_class_id',$request->academic_class_id)
                        ->where('status',true)
                        ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                            return $query->where('academic_department_id', $data['academic_department_id']);
                        })
                        ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                            return $query->where('academic_section_id', $data['academic_section_id']);
                        })
                        ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                            return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                        })
                        ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                            return $query->where('academic_session_id', $data['academic_session_id']);
                        })
                        ->when(!empty($data['academic_student_category_id']), function ($query) use ($data) {
                            return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                        })
                        ->when(!empty($data['academic_student_type_id']), function ($query) use ($data) {
                            return $query->where('academic_student_type_id', $data['academic_student_type_id']);
                        })
                        ->when(!empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                            return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                        })
                        ->orderBy('student_roll_number')
                        ->orderBy('academic_section_id')
                        ->orderBy('academic_class_group_id')
                        ->orderBy('academic_class_id')
                        ->orderBy('academic_department_id')
                        ->orderBy('academic_shift_id')
                        ->get(['id','user_id', 'site_id', 'student_roll_number', 'academic_class_id', 'academic_class_group_id',
                            'academic_session_id', 'academic_department_id']);


                }else{


                    $siteStudentIDs=StudentHistory::with(['student'=>function($query){
                        $query->select('id', 'username');
                    },'stClass','accGroup','section', 'department',
                        'siteStudentFeeDemandSlipDetails'=>function($query){
                            $query->where('status', true);

                        }])->when(!empty($data['student_history_id']), function ($query) use ($data) {
                        return $query->where('id', $data['student_history_id']);
                    })

                        ->where('academic_version_id',$request->academic_version_id)
                        ->where('academic_shift_id',$request->academic_shift_id)
                        ->where('academic_year_id',$request->academic_year_id)
                        ->where('academic_class_id',$request->academic_class_id)
                        ->where('status',true)
                        ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                            return $query->where('academic_department_id', $data['academic_department_id']);
                        })
                        ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                            return $query->where('academic_section_id', $data['academic_section_id']);
                        })
                        ->when(!empty($data['academic_student_category_id']), function ($query) use ($data) {
                            return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                        })
                        ->when(!empty($data['academic_student_type_id']), function ($query) use ($data) {
                            return $query->where('academic_student_type_id', $data['academic_student_type_id']);
                        })
                        ->when(!empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                            return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                        })
                        ->orderBy('student_roll_number')
                        ->orderBy('academic_section_id')
                        ->orderBy('academic_class_group_id')
                        ->orderBy('academic_class_id')
                        ->orderBy('academic_department_id')
                        ->orderBy('academic_shift_id')
                        ->get(['id','user_id', 'site_id', 'student_roll_number', 'academic_class_id', 'academic_class_group_id',
                            'academic_session_id', 'academic_department_id']);

                }

            }


        }
        $final_data = array();
        $mytime = Carbon::now();
        $today_date =  $mytime->toDateString();
        foreach ($siteStudentIDs as $key => $value){
//            return $value->siteStudentFeeDemandSlipDetails;

            $final_data[$key]['id'] = $value->id;
            $final_data[$key]['full_name'] = $value->full_name;
            $final_data[$key]['username'] = $value->student->username;
            $final_data[$key]['student_roll_number'] = $value->student_roll_number;
            $final_data[$key]['academic_class_id'] = $value->academic_class_id;
            $final_data[$key]['academic_class_group_id'] = $value->academic_class_group_id;
            $final_data[$key]['academic_department_id'] = $value->academic_department_id;
            $final_data[$key]['section'] = $value->section;
            $final_data[$key]['site_id'] = $value->site_id;
            $final_data[$key]['site_student_fee_demand_slip_details'] = $value->siteStudentFeeDemandSlipDetails;
            $final_data[$key]['reference_no'] = "";
            $final_data[$key]['payment_date'] = $today_date;
            $fee_fine_details = SiteStudentFeeFine::where('student_history_id', $value->id)->where('status', 1)->get();

            //=========due fine================
            $fine = 0;
            if (count($fee_fine_details)){
                foreach ($fee_fine_details as $k => $v){
                    $fine+= $v->fine_amount;

                }
            }

            //===============delay fine===========

            $delay_fine = 0;
            $previous_paid_amount = 0;
            if($value->siteStudentFeeDemandSlipDetails){
//                return $value->siteStudentFeeDemandSlipDetails->payment_from_date;

//                if($value->siteStudentFeeDemandSlipDetails->payment_from_date){
//                    return 'not null';
//                }else{
//                    return 'null';
//                }
//                return 'sorry';



                $payment_history = SiteStudentFeePaymentHistory::where('site_student_fee_demand_slip_details_id', $value->siteStudentFeeDemandSlipDetails->id)
                                                                ->get();
                if(count($payment_history)){
                    foreach ($payment_history as $ke => $vvl){
                        $previous_paid_amount+=$vvl->paid_amount;
                    }
//                    $previous_paid_amount = $value->siteStudentFeeDemandSlipDetails->total_amount - $payment_history->due_amount;
                }


//                $final_data[$key]['previous_paid_amount'] = $previous_paid_amount;


                if($value->siteStudentFeeDemandSlipDetails->payment_from_date){
//                    return 'date';
                    $mytime = Carbon::now();
                    $today_date =  $mytime->toDateString();
                    $fee_delay_fine = 0;
                    $start_date = $value->siteStudentFeeDemandSlipDetails->payment_from_date;
                    $end_date = $value->siteStudentFeeDemandSlipDetails->payment_to_date;

                    $period = CarbonPeriod::create($start_date, $end_date);

                    $delay_fine_test = 1;
                    $delay_fine = 0;

                    foreach ($period as $date) {
                        $formated_date =  $date->format('Y-m-d');
                        if($formated_date == $today_date){
                            $delay_fine_test = 0;
                        }
                    }

                    if($delay_fine_test==1){
                        $delay_fine = $value->siteStudentFeeDemandSlipDetails->delay_fine;
                    }else{
                        $delay_fine = 0;
                    }

                    $fee_delay_fine = $delay_fine;
                    $final_data[$key]['fine_amount'] = ($fee_delay_fine + $fine).".00";

                }else{
                    $fee_delay_fine = 0;
                    $final_data[$key]['fine_amount'] = ($fee_delay_fine + $fine).".00";
                }
//                $final_data[$key]['previous_paid_amount'] = $previous_paid_amount +  $final_data[$key]['fine_amount'];
                $final_data[$key]['total_amount'] = ($fee_delay_fine + $fine + $value->siteStudentFeeDemandSlipDetails->total_amount - $previous_paid_amount).".00";

            }else{
//                return 'not date';
                $final_data[$key]['total_amount'] = 0;

                $final_data[$key]['fine_amount'] = 0;
//                $final_data[$key]['total_amount'] = ($value->siteStudentFeeDemandSlipDetails->total_amount - $previous_paid_amount).".00";


            }

            $final_data[$key]['previous_paid_amount'] = $previous_paid_amount;


//            $final_data[$key]['fine_amount'] = $fine.".00";


        }
        return $final_data;


    }


    public function createSiteBaseMultipleStudentPayment(SiteStudentFeePaymentHistory $payment, Request $request){

//        return $request->SiteStudentFeeDemandList;

        //==============validation section================
        if(count($request->select_student_for_fee)>0){
            if($request->paid_by == 'bank'){
                $SiteStudentFeeDemandList=$request->SiteStudentFeeDemandList;
                $SiteStudentFeeDemandListCollecton=collect($SiteStudentFeeDemandList);
                $checkPaymentSelect=$SiteStudentFeeDemandListCollecton->whereIn('id',$request->select_student_for_fee);
                foreach ($checkPaymentSelect as $kk => $vv){
                    if(!$vv['reference_no']){
                        throw new Error('Sorry! this is bank payment. Reference no missing');
                    }
                }
            }
        }else{
            throw new Error('Please, select minimum one student');
        }

        if(!$request->paid_by){
            throw new Error('Please select paid by');
        }

        //==============entry section================
        DB::beginTransaction();
        try {

        $demandSlipIDs=[];
        $paymentHistoryIDs=[];
        foreach ($request->select_student_for_fee as $key => $value){
            $SiteStudentFeeDemandList=$request->SiteStudentFeeDemandList;
            $SiteStudentFeeDemandListCollecton=collect($SiteStudentFeeDemandList);
            $checkPaymentSelect=$SiteStudentFeeDemandListCollecton->where('id',$value)->first();
            if($checkPaymentSelect){
                //================previous student fee payment status change======================
                $check_payment_history = SiteStudentFeePaymentHistory::where('site_student_fee_demand_slip_details_id', $checkPaymentSelect['site_student_fee_demand_slip_details']['id'])
                    ->where('status', 1)->first();
                if($check_payment_history){
                    $check_payment_history->update([
                        'status'=>0,
                    ]);
                }
                //=================================create payment=================================

                $getLastPaymentSlipNo=$payment->where('site_id',$checkPaymentSelect['site_id'])->orderBy('id','desc')->first();
                $newPaymentSlipNo=($getLastPaymentSlipNo?$getLastPaymentSlipNo->voucher_no:1000)+1;

                $MultiplePayment=new SiteStudentFeePaymentHistory();
                $MultiplePayment->student_history_id=$value;
                $MultiplePayment->site_student_fee_demand_slip_details_id=$checkPaymentSelect['site_student_fee_demand_slip_details']['id'];
                $MultiplePayment->paid_amount=$checkPaymentSelect['total_amount'];
                $payment->due_amount=0;
                $MultiplePayment->voucher_no=$newPaymentSlipNo;
                $MultiplePayment->created_by=Auth::user()->id;
                $MultiplePayment->status=true;
                $MultiplePayment->payment_date=$checkPaymentSelect['payment_date'];
                $MultiplePayment->paid_by=$request->paid_by;
                $MultiplePayment->reference_no=$checkPaymentSelect['reference_no'];
                $MultiplePayment->save();

//                $latest_paymen_data = SiteStudentFeePaymentHistory::orderBy('id', 'DESC')->first();
                $paymentHistoryIDs[] = $MultiplePayment->id;

                $demandSlipIDs[]=$checkPaymentSelect['site_student_fee_demand_slip_details']['id'];

                //=======================student fee fine status change===========================

                $fee_due_fine = SiteStudentFeeFine::where('student_history_id', $value)->where('status', 1)->update([
                    'status' => 0,
                ]);

                //============================check delay fine=================================

                $dmndSlipId = $checkPaymentSelect['site_student_fee_demand_slip_details']['id'];
                $demand_slip_details = SiteStudentFeeDemandSlipDetails::where('id', $dmndSlipId)->first();
//                return $demand_slip_details;
                if($demand_slip_details && $demand_slip_details->payment_from_date){
                    $mytime = Carbon::now();
                    $today_date =  $mytime->toDateString();
                    $fee_delay_fine = 0;
                    $start_date = $demand_slip_details->payment_from_date;
                    $end_date = $demand_slip_details->payment_to_date;

                    $period = CarbonPeriod::create($start_date, $end_date);

                    $delay_fine_test = 1;
                    $delay_fine = 0;

                    foreach ($period as $date) {
                        $formated_date =  $date->format('Y-m-d');
                        if($formated_date == $today_date){
                            $delay_fine_test = 0;
                        }
                    }

                    if($delay_fine_test==1){
                        $delay_fine = $demand_slip_details->delay_fine;
                    }else{
                        $delay_fine = 0;
                    }
                    if($delay_fine>0){
                        $payment_history = SiteStudentFeePaymentHistory::where('site_student_fee_demand_slip_details_id', $dmndSlipId)->first();
                        $fee_fine_create = SiteStudentFeeFine::create([
                            'site_student_fee_demand_slip_details_id' => $dmndSlipId,
                            'fine_amount' => $delay_fine,
                            'student_history_id' => $value,
                            'site_student_fee_payment_history_id' => $payment_history->id,
                            'status' => 0,
                            'fee_type' => 'delayfine',
                        ]);

                    }

                }

                //======================notification========================
                $payment_history = SiteStudentFeePaymentHistory::where('site_student_fee_demand_slip_details_id', $dmndSlipId)->first();
                $paymentHistoryDetails = SiteStudentFeePaymentHistory::where('student_history_id', $payment_history->student_history_id)->where('status', 1)->with('studentHistory')->first();

                dispatch(new PaymentHistoryJob($paymentHistoryDetails));

                //======================end========================


            }


        }

        $paymentHistoryIDsWithComa = implode(',',$paymentHistoryIDs);


        SiteStudentFeeDemandSlipDetails::whereIn('id', $demandSlipIDs)
            ->update(['status' => false]);

//        return Response::json(['message' => 'information Save Successfully!', 'mode' => 'Saved!'], 200);
            DB::commit();
            return Response::json(['message' => 'Payment Done Successfully!', 'mode' => 'Saved!', 'paymentHistoryIDs' => $paymentHistoryIDsWithComa], 200);

        }  catch (ValidationException $exception) {
            DB::rollBack();
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        }catch (Exception $exception) {
            DB::rollBack();
            return Response::json(['message' => $exception->getMessage()], 410);
        }


    }


    public function store(Request $request)
    {
//        return $request;
//        $fine_ids = $request->site_std_fee_fine_id;
//        $fee_fine_update = SiteStudentFeeFine::whereIn('id', $fine_ids)->where('site_student_fee_payment_history_id', "=", null)->get();
//        if(count($fee_fine_update)>0){
//            foreach ($fee_fine_update as $kke => $vvll){
//                $vvll->update([
//                    'status' => 0,
//                    'site_student_fee_payment_history_id' => 125,
//                ]);
//            }
//
//        }
//        return $request;

        if($request->total_amount > 0){
            if($request->paied_amount == null || $request->paied_amount == 0){
                return Response::json(['message' => 'Please enter pay amount!'], 411);
            }
        }
        if(!$request->paid_by){
            throw new Error('Please select paid by');
        }
        if($request->paid_by == 'bank' && !$request->reference_no){
            throw new Error('This is bank payment! Please write reference no');
        }
//        return 'sorry';

        DB::beginTransaction();
        try {

        $slip_id=$request->slip_no-100000;

        $demand_slip_details = SiteStudentFeeDemandSlipDetails::where('id', $slip_id)->first();

         //------------------previous payment status change------------------------

//        $check_previous_payment_status = SiteStudentFeePaymentHistory::where('student_history_id', $demand_slip_details->student_history_id)->where('status', 1)->first();
//        if($check_previous_payment_status){
//            $check_previous_payment_status->update([
//               'status' => 0,
//            ]);
//        }
        //------------------previous payment status change end------------------------
//        $student_payment_save = "";
        $check_payment = SiteStudentFeePaymentHistory::
            where('site_student_fee_demand_slip_details_id', $demand_slip_details->id)
            ->get();


        if(count($check_payment)>0){
            foreach ($check_payment as $kkk => $vvv){
                $vvv->update([
                    'status' => 0,
                ]);
                if($vvv->due_amount == 0){
                    return Response::json(['message' => 'Sorry! This Payment Already Taken!'], 411);
                }
            }
        }else{
            //------------------previous payment status change------------------------

            $check_previous_payment_status = SiteStudentFeePaymentHistory::where('student_history_id', $demand_slip_details->student_history_id)->where('status', 1)->get();
            if(count($check_previous_payment_status)){
                foreach ($check_previous_payment_status as $kkkk => $vvvv){
                    $vvvv->update([
                        'status' => 0,
                    ]);
                }

            }
        }
        //=========================== new payment ===================================
            $student_payment_save = new SiteStudentFeePaymentHistory();
            $student_payment_save->payment_date = $request->payment_date;
            $student_payment_save->site_student_fee_demand_slip_details_id = $demand_slip_details->id;
            $student_payment_save->student_history_id = $demand_slip_details->student_history_id;
            if($request->extraPayment){
                $student_payment_save->paid_amount = $request->paied_amount + $request->extraPayment;
            }else{
                $student_payment_save->paid_amount = $request->paied_amount;
            }
            $student_payment_save->due_amount = $request->due_amount;
            $student_payment_save->created_by = Auth::user()->id;
            $student_payment_save->status = 1;
            $student_payment_save->paid_by = $request->paid_by;
            $student_payment_save->reference_no = $request->reference_no;

            $payment_history = SiteStudentFeePaymentHistory::orderBy('voucher_no', 'desc')->pluck('voucher_no')->first();

            if ($payment_history){
                $student_payment_save->voucher_no = $payment_history+1;
            }else{
                $student_payment_save->voucher_no = 10001;
            }
        //    dd($student_payment_save);

         //   $student_payment_save->save();
            if($student_payment_save->save()){
                if($request->due_amount == 0){
                    $demand_slip_details->status = 0;
                }
//                $demand_slip_details->status = 0;
                $demand_slip_details->save();

                //==============fine section===================

                $fee_delay_array = [];
                $fee_due_fine_id_array = [];

                $last_payment_history_get = SiteStudentFeePaymentHistory::where('status', 1)->orderBy('id','DESC')->first();

                if($request->fee_due_fine>0){

                    $fine_ids = $request->site_std_fee_fine_id;
                    $fee_fine_update = SiteStudentFeeFine::whereIn('id', $fine_ids)->where('site_student_fee_payment_history_id', "=", null)->get();

                    if(count($fee_fine_update)>0){
                        foreach ($fee_fine_update as $kke => $vvll){
                            $vvll->update([
                                'status' => 0,
                                'site_student_fee_payment_history_id' => $last_payment_history_get->id,
                            ]);
                        }
                    }
//                    $fee_fine_update = SiteStudentFeeFine::whereIn('id', $fine_ids)->update([
//                        'status' => 0,
//                        'site_student_fee_payment_history_id' => $last_payment_history_get->id,
//                    ]);

                }

                $fee_fine_generate = SiteStudentFeeFine::where('site_student_fee_demand_slip_details_id', $slip_id)
                    ->where('fee_type','delayfine')->first();
                if(!$fee_fine_generate){
                    if($request->fee_delay_fine>0){

                        $fee_fine_create = SiteStudentFeeFine::create([
                            'site_student_fee_demand_slip_details_id' => $slip_id,
                            'fine_amount' => $request->fee_delay_fine,
                            'status' => 0,
                            'site_student_fee_payment_history_id' => $last_payment_history_get->id,
                            'student_history_id' => $demand_slip_details->student_history_id,
                            'fee_type' => 'delayfine',
                            'created_date' => $request->payment_date,
                        ]);
                    }
                }

                if($request->extraPayment){
                    $fee_fine_create = SiteStudentFeeFine::create([
                        'site_student_fee_demand_slip_details_id' => $slip_id,
                        'fine_amount' => $request->extraPayment,
                        'status' => 0,
                        'site_student_fee_payment_history_id' => $last_payment_history_get->id,
                        'student_history_id' => $demand_slip_details->student_history_id,
                        'fee_type' => 'extrafine',
                        'created_date' => $request->payment_date,
                    ]);
                }
            }

            //=========================sms================================

            if($request->sendSms){
                $student_history = StudentHistory::where('id', $demand_slip_details->student_history_id)->with('student')->first();
                $phone_number =  $student_history->student->contact_number;
                $student_name = $student_history->student->full_name;
                $paid_amount = $request->paied_amount;
                $due_amount = $request->due_amount;
               // $paypment_date = Carbon::today();
                $paypment_date = Carbon::now();;
                $the_site = SiteInfo::findOrFail(Session::get('SITE_ID'));

//                        $url = config('app.url');

                $sms_txt = "Payment Successful";
                $sms_txt .=', '.$student_name;
                $sms_txt .=', '.'Paid:'.$paid_amount;
                $sms_txt .=', '.'Due:'.$due_amount;
                $sms_txt .=', '.'Payment Date:'.$paypment_date;
                $sms_txt .=', '.'Thanks:' . $the_site->site_name;

                $tt = $this->sendSms($the_site->id, [$phone_number] ,$sms_txt );
            }

            //======================notification========================

            $paymentHistoryDetails = SiteStudentFeePaymentHistory::where('student_history_id', $demand_slip_details->student_history_id)->where('status', 1)->with('studentHistory')->first();

            dispatch(new PaymentHistoryJob($paymentHistoryDetails));

            //======================end========================

            DB::commit();
            $voucher_no = $student_payment_save->voucher_no??null;
            return $voucher_no;
           // return Response::json(['message' => 'information Save Successfully!','voucher_no'=>$voucher_no, 'mode' => 'Saved!'], 200);

        }  catch (ValidationException $exception) {
            DB::rollBack();
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        }catch (Exception $exception) {
            DB::rollBack();
            return Response::json(['message' => $exception->getMessage()], 410);
        }



        // $slip_id=$request->slip_no-100000;

        // $demandslipid=GlobalSiteStudentFeeDemandSlipDetails::where('id',$slip_id)
        //     ->first();

        // $getLastPaymentSlipNo=$payment->where('site_id',$demandslipid->site_id)->orderBy('id','desc')->first();

        // $newPaymentSlipNo=($getLastPaymentSlipNo?$getLastPaymentSlipNo->voucher_no:1000)+1;

        // $payment->academic_group_id=Session::get('ACADEMIC_GROUP_ID');
        // $payment->student_history_id=$demandslipid->student_history_id;
        // $payment->site_student_fee_demand_slip_details_id=$demandslipid->id;
        // $payment->paid_amount=$request->paid_amount;
        // $payment->due_amount=($request->total_amount)-($request->paid_amount);
        // $payment->voucher_no=$newPaymentSlipNo;
        // $payment->created_by=Auth::user()->id;
        // $payment->site_id=$demandslipid->site_id;
        // $payment->site_group_id=Session::get('SITE_GROUP_ID');
        // $payment->status=true;
        // $payment->payment_date=Carbon::today();
        // $payment->save();

        // $demandslipid->status=false;
        // $demandslipid->save();

        // return Response::json(['message' => 'information Save Successfully!', 'mode' => 'Saved!'], 200);

    }
  
}
